% Test the method polysyms.real_imag
function test_suite = test_real_imag %#ok<*STOUT>
initTestSuite;

function testValidNumber1 %#ok<*DEFNU>
p = polysym('1.23498e-10*I');
[re,im] = p.real_imag;
assertEqual(re,polysym(0))
assertEqual(im,polysym('1.23498e-10'))

function testValidNumber2
p = polysym('10');
[re,im] = p.real_imag;
assertEqual(re,polysym(10))
assertEqual(im,polysym(0))

function testValidNumber3
p = polysym('3.23234*I');
[re,im] = p.real_imag;
assertEqual(re,polysym(0))
assertEqual(im,polysym('3.23234'))

function testValidNumber4
p = polysym('-4');
[re,im] = p.real_imag;
assertEqual(re,polysym(-4))
assertEqual(im,polysym(0))

function testValidNumber5
p = polysym('1e-24 - 10 * I');
[re,im] = p.real_imag;
assertEqual(re,polysym(1e-24))
assertEqual(im,polysym(-10))

function testValidNumber6
p = polysym('1e-24 + 10*I');
[re,im] = p.real_imag;
assertEqual(re,polysym(1e-24))
assertEqual(im,polysym('+10'))

function testValidNumber7
p = polysym(0.0000234i);
[re,im] = p.real_imag;
assertEqual(re,polysym(0))
assertEqual(im,polysym(0.0000234))

function testValidNumber8
p = polysym('1.234E10');
[re,im] = p.real_imag;
assertEqual(re,polysym('1.234E10'))
assertEqual(im,polysym(0))

function testValidNumber9
p = polysym('1.e10');
[re,im] = p.real_imag;
assertEqual(re,polysym('1.e10'))
assertEqual(im,polysym(0))

function testValidNumber10
p = polysym('.1e10* I');
[re,im] = p.real_imag;
assertEqual(re,polysym(0))
assertEqual(im,polysym('.1e10'))

function testValidNumber11
p = polysym('.1');
[re,im] = p.real_imag;
assertEqual(re,polysym('.1'))
assertEqual(im,polysym(0))

function testValidNumber12
p = polysym('- 1e10');
[re,im] = p.real_imag;
assertEqual(re,polysym('-1e10'))
assertEqual(im,polysym(0))

function testValidNumber13
p = polysym('.10234 + 10.3324e10*I');
[re,im] = p.real_imag;
assertEqual(re,polysym('.10234'))
assertEqual(im,polysym('+10.3324e10'))

function testInvalidNumber1
p = polysym('e10 *I');
f = @() p.real_imag;
assertExceptionThrown(f,'polysym:write_number:notNumber')

function testInvalidNumber2
p = polysym('.23e*I');
f = @() p.real_imag;
assertExceptionThrown(f,'polysym:write_number:notNumber')

function testTooManyImag
p = polysym('.1*I + .2*I');
f = @() p.real_imag;
assertExceptionThrown(f,'polysym:write_number:tooMany')

function testTooManyReal
p = polysym('.1 + .2 + 3.14*I');
f = @() p.real_imag;
assertExceptionThrown(f,'polysym:write_number:tooMany')